<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Laravel\Sanctum\HasApiTokens;


class DetailPengembalian extends Model
{
    use HasFactory;
    use HasApiTokens;
    public $timestamps = true;



    protected $table = 'tb_detail_pengembalian';


    protected $fillable = [
        'id_pengembalian',
        'id_barang',
        'jumlah',
        'harga',
        'sub_total',
        'created_at',
        'updated_at',
    ];

    // Relasi: Detail pengembalian milik 1 pengembalian
    public function pengembalian()
    {
        return $this->belongsTo(Pengembalian::class, 'id_pengembalian');
    }

    // (Opsional) Relasi ke produk
    public function produk()
    {
        return $this->belongsTo(Produk::class, 'id_produk');
    }
}
